//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------

int PqMode;
Texture2D overlay;            // Color texture for mesh
float MaxCLL = 1000;
float y_hdr_ref     = 203.0f;    
float de_saturation = 0.0f;
float sdr_peak      = 100.0f;
float hlg_peak      = 1000.0f;//hlg is dependent on the peak white of the  master display so it is a relative encoding!! //according to BT.2390-3 Lw = 392
float pq_peak       = 10000.0f;//pq is absolute encoding
#define EQN_EPS 1e-5f
#define MP_REF_WHITE 203.0f
#define MP_REF_WHITE_HLG 3.17955f
#define sdr_avg  0.25f
//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};
bool iszero(float value) 
{
	return value >= -EQN_EPS && value <= EQN_EPS;
}
float3 PQ_EOTF_12(float3 pq_sinal) 
{

    float m1 = (2610.0f) / (4096.0f * 4.0f);
    float m2 = (2523.0f * 128.0f) / 4096.0f;
    float c1 = (3424.0f) / 4096.0f;
    float c2 = (2413.0f *  32.0f) / 4096.0f;
    float c3 = (2392.0f *  32.0f) / 4096.0f;

    float3 sinal = clamp(pq_sinal, 0.0f, 1.0f);
    float3 tempValue = pow(sinal, (1.0f / m2));
    tempValue = (pow(max(0.0f, (tempValue - c1)) / (c2 - c3 * tempValue), (1.0f / m1)));
    return tempValue * 10000.0f / MP_REF_WHITE;
};
float3 HLG_INV_OETF_12(float3 hlg_signal) 
{
	float m_tfScale      = 12.0f; //19.6829249; // transfer function scaling - assuming super whites
	float m_invTfScale   = 1.0f / m_tfScale;
	float m_normalFactor = 1.0f;
	float m_a = 0.17883277f;
	float m_b = 0.28466892f;
	float m_c = 0.55991073f;

    float3 tmp3 = hlg_signal <= 0.5f ? hlg_signal * hlg_signal * 4.0f : exp((hlg_signal - m_c) / m_a) + m_b;
    tmp3 *= 1.0f / MP_REF_WHITE_HLG;
    return tmp3;
};
float3 HLG_OOTF_12(float3 RGBs,float Lw,float Lb) 
{
    float peak = 1000.0f / MP_REF_WHITE;
    float3 RGBd;
	float Ys    = 0.2627f * RGBs.x + 0.6780f * RGBs.y + 0.0593f * RGBs.z;
    float gamma =  1.2f + 0.42f * log10(Lw / 1000.0f);
    gamma = max(1.0f, gamma);
    float factor = peak / pow(12.0f / MP_REF_WHITE_HLG, gamma) * pow(Ys, gamma - 1.0f);
	RGBd.x = RGBs.x * factor;
	RGBd.y = RGBs.y * factor;
	RGBd.z = RGBs.z * factor;    
    return RGBd;
};
float3 hable3(float3 x) 
{
    float A = 0.15f, B = 0.50f, C = 0.10f, D = 0.20f, E = 0.02f, F = 0.30f;
    return (x * (x * A + B * C) + D * E) / (x * (x * A + B) + D * F) - E / F;
}
float BT1886_INV_EOTF(float Rd) 
{
	float m_gamma = 2.4f;
	float m_inverseGamma = 1.0f / m_gamma;
    float c = clamp(Rd,0.0f,1.0f);
	return pow(c, m_inverseGamma);
}
PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
	PS_OUTPUT Output;
	float2 tc = In.TextureUV;
	
    float3 bt2020_bt709_0 = float3(1.66049695f,-0.587656736f,-0.0728399456f);
    float3 bt2020_bt709_1 = float3(-0.124547064f,1.13289523f,-0.00834798440f);
    float3 bt2020_bt709_2 = float3(-0.0181536824f,-0.100597292f,1.11875105f);
    float hdr_peak_luminance = hlg_peak;
	float4 color = overlay.Sample(TextureSampler, tc);
	if(PqMode == 1) hdr_peak_luminance = pq_peak;      
	float sig_peak = 1000.0f / MP_REF_WHITE;
	color.xyz = clamp(color.xyz, float3(0.0f,0.0f,0.0f), float3(1.0f,1.0f,1.0f));
	if(PqMode == 1)
	{
		color.xyz = PQ_EOTF_12(color.xyz);
		sig_peak = MaxCLL / MP_REF_WHITE;
	}
	else
	{
		color.xyz = HLG_INV_OETF_12(color.xyz);      
		color.xyz = HLG_OOTF_12(color.xyz,1000.0f,0.0f);      
	}  
	int sig_idx   = -1;
	float sig_max = max(max(color.x,color.y),color.z);
	if(iszero(sig_max - color.x)) sig_idx = 0;
	if(iszero(sig_max - color.y)) sig_idx = 1;
	if(iszero(sig_max - color.z)) sig_idx = 2;      
	float sig_avg = 0.250000f;
	float3 sig    = min(color.xyz, sig_peak);   
	float dst_scale = 200.0f / 203.0f;
	if(dst_scale >1.0f)
	{
		sig *= 1.0f / dst_scale;
		sig_peak *= 1.0f / dst_scale;
	}
	float sig_orig = 0.0f;
	if(sig_idx == 0)
	{
		sig_orig = sig.x;
	}
	if(sig_idx == 1)
	{
		sig_orig = sig.y;
	}
	if(sig_idx == 2)
	{
		sig_orig = sig.z;
	}
	float max_boost = 1.0f;
	float slope = min(max_boost, sdr_avg / sig_avg);
	sig *= slope;
	sig_peak *= slope;
	sig = hable3(max(float3(0.0f,0.0f,0.0f), sig)) / hable3(float3(sig_peak,sig_peak,sig_peak)).x;
	//sig = DX11DSK(sig);
	sig_max = 0.0f;
	if(sig_idx == 0)
	{
		sig_max = sig.x;
	}
	if(sig_idx == 1)
	{
		sig_max = sig.y;
	}
	if(sig_idx == 2)
	{
		sig_max = sig.z;
	}
	float3 sig_lin = color.xyz * (sig_max / sig_orig);
	int desat = 1;
	float desat_exp = 1.5f;
	if(desat > 0)
	{
		float base = 0.18f * dst_scale;
		float coeff = max(sig_max - base, 1e-6f) / max(sig_max, 1.0f);
		coeff = (float)(desat) * pow(coeff, desat_exp);
		color.xyz = lerp(sig_lin, dst_scale * sig, coeff);
	}
	else
	{
		color.xyz = sig_lin;
	}      
	float R_SDR_709 = dot(bt2020_bt709_0,color.xyz);
	float G_SDR_709 = dot(bt2020_bt709_1,color.xyz);
	float B_SDR_709 = dot(bt2020_bt709_2,color.xyz);
	color.xyz = float3(R_SDR_709,G_SDR_709,B_SDR_709);
			   
	float cmin = min(min(color.x, color.y), color.z);
	if (cmin < 0.0f) 
	{
		float luma = 0.2627f * color.x + 0.6780f * color.y + 0.0593f * color.z; 
		float coeff = cmin / (cmin - luma);
		color.xyz = lerp(color.xyz, float3(luma,luma,luma), coeff); 
	}
	float cmax = 1.0f / dst_scale * max(max(color.x, color.y), color.z);        
	if (cmax > 1.0f) color.xyz /= cmax;
	float dst_range = dst_scale;
	color.xyz *= 1.0f / dst_range;
	// delinearize
	color.xyz = clamp(color.xyz, 0.0f, 1.0f);
	color.x = BT1886_INV_EOTF(color.x);
	color.y = BT1886_INV_EOTF(color.y);
	color.z = BT1886_INV_EOTF(color.z);        
    Output.RGBColor = color;
    return Output;
}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}
